/*
 * Decompiled with CFR 0.152.
 */
package fuzs.completionistsindex.client.gui.screens.inventory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.completionistsindex.CompletionistsIndex;
import fuzs.completionistsindex.client.gui.screens.inventory.IndexViewScreen;
import fuzs.completionistsindex.config.ClientConfig;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.achievement.StatsUpdateListener;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.stats.StatsCounter;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;

public class ModsIndexViewScreen
extends IndexViewScreen
implements StatsUpdateListener {
    private static final Component PENDING_TEXT = Component.m_237115_((String)"multiplayer.downloadingStats");
    public static final String ALL_ITEMS_KEY = "__ALL__";
    private final Map<String, List<ItemStack>> allItemsByMod = ModsIndexViewScreen.getAllItemsByMod();
    private boolean isLoading = true;

    public ModsIndexViewScreen(Screen lastScreen) {
        super(lastScreen);
    }

    private static Map<String, List<ItemStack>> getAllItemsByMod() {
        NonNullList searchTabItems = NonNullList.m_122779_();
        CreativeModeTab.f_40754_.m_6151_(searchTabItems);
        List allItems = searchTabItems.stream().map(ItemStack::m_41720_).distinct().filter(Predicate.not(arg_0 -> ((ClientConfig)CompletionistsIndex.CONFIG.get(ClientConfig.class)).blacklist.contains(arg_0))).map(ItemStack::new).collect(Collectors.toList());
        LinkedHashMap allItemsByMod = Maps.newLinkedHashMap();
        allItemsByMod.put(ALL_ITEMS_KEY, allItems);
        for (ItemStack item : allItems) {
            allItemsByMod.computeIfAbsent(Registry.f_122827_.m_7981_((Object)item.m_41720_()).m_135827_(), modId -> Lists.newArrayList()).add(item);
        }
        if (allItemsByMod.size() == 2) {
            allItemsByMod.remove(ALL_ITEMS_KEY);
        }
        return (Map)allItemsByMod.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ImmutableList.copyOf((Collection)((Collection)e.getValue()))));
    }

    public void m_7819_() {
        if (this.isLoading) {
            this.isLoading = false;
            this.rebuildPages();
        }
    }

    @Override
    protected void rebuildPages() {
        if (!this.isLoading) {
            super.rebuildPages();
        }
    }

    @Override
    protected List<IndexViewScreen.IndexViewPage.Entry> getPageEntries() {
        StatsCounter stats = this.f_96541_.f_91074_.m_108630_();
        return this.allItemsByMod.entrySet().stream().map(entry -> IndexViewScreen.IndexViewPage.modItemEntry((String)entry.getKey(), (List)entry.getValue(), stats, this.f_96547_)).sorted(this.getComparator()).toList();
    }

    @Override
    protected void m_7856_() {
        this.isLoading = true;
        this.f_96541_.m_91403_().m_104955_((Packet)new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.REQUEST_STATS));
        super.m_7856_();
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float tickDelta) {
        super.m_6305_(poseStack, mouseX, mouseY, tickDelta);
        if (this.isLoading) {
            Component component = PENDING_TEXT;
            this.f_96547_.m_92889_(poseStack, component, (float)((this.f_96543_ - this.f_96547_.m_92852_((FormattedText)component)) / 2), (float)(this.topPos + 99 - 18), 0);
            component = Component.m_237113_((String)f_97124_[(int)(Util.m_137550_() / 150L % (long)f_97124_.length)]);
            this.f_96547_.m_92889_(poseStack, component, (float)((this.f_96543_ - this.f_96547_.m_92852_((FormattedText)component)) / 2), (float)(this.topPos + 99), 0);
        }
    }
}

